import pickle as pkl
from matplotlib import pyplot as plt
import numpy as np

SHOW_FINAL = True


def smooth(l, width=50):
    ans = list()
    for i in range(len(l) - width):
        ans.append(sum(l[i:i+width]) / width)
    return ans


def show_arithmetic():
    result = pkl.load(open("arithmetic_mod7/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("arithmetic_mod7 ", {k: float(np.mean([t[k] for t in result][:])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_one_line_addition():
    result = pkl.load(open("one_line_addition/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("one_line_addition ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_two_line_addition():
    result = pkl.load(open("two_line_addition/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("two_line_addition ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_one_line_multiplication():
    result = pkl.load(open("one_line_multiplication/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("one_line_multiplication ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_multiplication():
    result = pkl.load(open("multiplication/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("multiplication ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_division():
    result = pkl.load(open("division/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("division ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))


def show_two_line_parity():
    result = pkl.load(open("two_line_parity/result.pkl", "rb"))
    keys = list(result[0].keys())
    if SHOW_FINAL:
        print("two_line_parity ", {k: float(np.mean([t[k] for t in result])) for k in keys})
        return
    for k in keys:
        plt.plot(smooth([t[k] for t in result]))
