import re

def dissect_expression(expression):
    operations = []
    temp_var_counter = [0]
    var_name, expr = expression.split('=', 1)

    def generate_temp_var():
        temp_var_counter[0] += 1
        return f"{var_name.strip()}_temp_{temp_var_counter[0]}"

    def process_expression(exp):
        # Process nested function calls first
        count_iter = 0
        while (nested_func_match := re.search(r'\[([^]]+)\]\(([^()]+)\)', exp)):
            count_iter += 1
            if count_iter > 20:
                raise Exception("Infinite loop detected while processing nested function calls")
            func_name = nested_func_match.group(1)
            args = nested_func_match.group(2)

            # Process arithmetic operations within these arguments
            args, new_ops = process_arithmetic_ops(args)
            operations.extend(new_ops)

            # Replace the entire function call with a temporary variable
            temp_var = generate_temp_var()
            operations.append(f"{temp_var} = [{func_name}]({args})")
            exp = exp[:nested_func_match.start()] + temp_var + exp[nested_func_match.end():]

        # After processing nested function calls, process remaining arithmetic operations
        final_exp, new_ops = process_arithmetic_ops(exp)
        operations.extend(new_ops)
        return final_exp

    def process_arithmetic_ops(args):
        new_operations = []
        count_iter = 0
        while (arithmetic_match := re.search(r'(\b\w+\b)\s*([\+\-\*/])\s*(\b\w+\b)', args)):
            count_iter += 1
            if count_iter > 20:
                raise Exception("Infinite loop detected while processing nested function calls")
            left_operand = arithmetic_match.group(1)
            operator = arithmetic_match.group(2)
            right_operand = arithmetic_match.group(3)

            # Replace the arithmetic operation with a temporary variable
            temp_var = generate_temp_var()
            operation = f"{left_operand} {operator} {right_operand}"
            new_operations.append(f"{temp_var} = {operation}")
            args = args[:arithmetic_match.start()] + temp_var + args[arithmetic_match.end():]

        return args, new_operations

    # Initial processing
    
    processed_expr = process_expression(expr.strip())
    if temp_var_counter[0] > 0:  # If there were replacements, assign the last temp_var to the var_name
        last_op = operations[-1]
        operations[-1] = f"{var_name}={last_op.split('=')[1]}"
    else:  # Direct assignment without temp variables
        operations = [f"{var_name.strip()} = {processed_expr}"]

    return operations

if __name__ == '__main__':
    input_expression = 'pay_amount = [if_else](average_points >= minimum_points_for_higher_pay, higher_pay_amount, lower_pay_amount)'
    disassembled_ops = dissect_expression(input_expression)
    for op in disassembled_ops:
        print(op)
