def find_functions(s):
    expressions = []
    stack = []  # To keep track of '[' positions and expressions start
    i = 0
    while i < len(s):
        if s[i] == '[':
            stack.append(i)  # Remember the position of '['
        elif s[i] == ']':
            # Look ahead for a '(' to confirm it's an expression
            if i + 1 < len(s) and s[i + 1] == '(':
                depth = 1  # Depth of parentheses
                for j in range(i + 2, len(s)):
                    if s[j] == '(':
                        depth += 1
                    elif s[j] == ')':
                        depth -= 1
                        if depth == 0:
                            # Found the matching ')', so we found a full expression
                            start = stack.pop()  # Get the start of this expression
                            expressions.append(s[start:j+1])
                            i = j  # Move the index to the end of this expression
                            break
        i += 1
    return expressions

if __name__ == '__main__':
    output = find_functions('[A]([B]([C](a, b)), asd) * [hah](2) + 1')
    print(output)