import os
import argparse
from evaluator import Evaluator

def main(args):
    e = Evaluator(args)
    if args.evaluate:
        e.inference(args.temp)
    else:
        print(f"task:{args.task}\tmethod:{args.method}")
    e.evaluate()

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Evaluate a large language model on a specified task.")
    parser.add_argument('--llm', type=str, default='gemini-pro', help='Name of the large language model to evaluate.')
    parser.add_argument('--task', type=str, help='Name of the task to evaluate the model on.')
    parser.add_argument('--method', type=str, help='Name of the method to retrieve')
    parser.add_argument('--temp', type=float, default=1e-5)
    parser.add_argument('--gpus', type=str, default="0")
    parser.add_argument('--evaluate', action='store_false')

    args = parser.parse_args()
    
    os.environ["CUDA_VISIBLE_DEVICES"] = args.gpus

    main(args)