import os
import json


def read_list_from_json(path):
    """
    从JSON文件读取数据，返回列表。

    参数:
    - path: 字符串，指定JSON文件的路径。

    返回:
    - 从文件中读取的列表。
    """
    with open(path, 'r', encoding='utf-8') as file:
        list_data = json.load(file)
    return list_data


def write_list_to_json(path, list_data):
    folder_path = os.path.dirname(path)
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)
    
    with open(path, 'w') as file:
        json.dump(list_data, file, indent=4)

def read_prompt(path):
    pred_dense = read_list_from_json(path)
    try:
        golds = [p['answer'] for p in pred_dense]
    except:
        golds = [p['final_answer'] for p in pred_dense]
    prompts = [p['prompt'] for p in pred_dense]
    return prompts, golds