# Supporting Materials Structure

```python
├─code
│  ├─generate_frr # Generate Formalized Reasoning Representation (FRR)
│  ├─graph_based_retrieve # Retrieve ICEs using GraphIC
│  └─test_results # Test the retrieved results
└─prompts
    ├─graphic # Prompts used to generate FRR
    └─skill_knn # Prompts used to reproduce Skill-kNN
```

# GraphIC Reproduce

## Environment Setup

The experiment requires the following environment: Python 3.10.4, CUDA 12.1, PyTorch 2.4.0.

To set up the environment, use the following commands:

```bash
conda create -n graphic python=3.10.4
conda activate graphic
pip install torch==2.4.0 torchvision==0.19.0 torchaudio==2.4.0 --index-url https://download.pytorch.org/whl/cu121
cd code/
pip install -r requirements.txt
```

## GraphIC Model

Using the ProofWriter dataset as an example, follow these steps to reproduce the GraphIC model:

1. Generate the Formalized Reasoning Representation (FRR):

```bash
cd generate_frr/
python main.py
```

2. Retrieve ICEs using GraphIC:

```bash
cd graph_based_retrieve/
cp -r ../generate_frr/frrs ./frrs
python main_graph.py --task proofwriter --llm llama-3.1-8b-instruct
python main_retrieve.py --task proofwriter --llm llama-3.1-8b-instruct
```

3. Test the results:

```bash
cd test_results
cp -r ../graph_based_retrieve/results ./results
python main.py --llm llama-3.1-8b-instruct --task proofwriter --method bayes_ppr2_2-mean-0p1_ppr2 --gpus 0,1,2,3
```