import os
import json

def write_json(path, list_data):
    if not os.path.exists(os.path.dirname(path)):
        os.makedirs(os.path.dirname(path))
    with open(path, 'w') as file:
        json.dump(list_data, file, indent=4)

def load_json(path):
    with open(path, 'r') as file:
        list_data = json.load(file)
    return list_data

def read_txt(path):
    try:
        with open(path, 'r', encoding='utf-8') as file:
            content = file.read()
        return content
    except FileNotFoundError:
        raise FileNotFoundError(f'File not found: {path}')

def save_to_jsonl(dict_list, file_path):
    directory = os.path.dirname(file_path)
    if not os.path.exists(directory):
        os.makedirs(directory)
    with open(file_path, 'w', encoding='utf-8') as file:
        for item in dict_list:
            json_line = json.dumps(item, ensure_ascii=False)
            file.write(json_line + '\n')

def load_jsonl(jsonl_file_path):
    dict_list = []
    with open(jsonl_file_path, 'r', encoding='utf-8') as file:
        for line in file:
            dict_list.append(json.loads(line.strip()))
    return dict_list

def save_jsonl_str(jsonl_string, file_path):
    with open(file_path, 'w', encoding='utf-8') as file:
        file.write(jsonl_string)