import argparse
import copy
import subprocess as sp
import os
import time
import subprocess
from turtle import st
import nvidia_smi

# Specify the folders to check for config files
start_queue_folder = 'configs/start_queue'
running_folder = 'configs/running'
finished_folder = 'configs/finished'
START_COUNTER = 5
SLEEP_SECONDS = 5

def get_gpu_memory():
    command = "nvidia-smi --query-gpu=memory.free --format=csv"
    memory_free_info = sp.check_output(command.split()).decode('ascii').split('\n')[:-1][1:]
    memory_free_values = [int(x.split()[0]) for i, x in enumerate(memory_free_info)]
    return memory_free_values

# Function to check for available GPUs
def get_free_gpu(available_gpus, needs_ram):
    
    gpu_mem_list = get_gpu_memory()  # [2475, 16139, 4267, 7720, 12046]
    
    found_gpu = None
    for gpu in available_gpus:
        if gpu_mem_list[gpu] > needs_ram:
            found_gpu = gpu
            print(f'Found free GPU {gpu} with {gpu_mem_list[gpu]} MB')
    if found_gpu is None:
        print("No free GPU found")
    return found_gpu

# Function to check for config files
def find_config_files(parent_dir):
    # list all files in the start_queue_folder and subdirectories
    config_files = []
    for root, dirs, files in os.walk(parent_dir):
        for file in files:
            if file.endswith('.yml'):
                config_files.append(os.path.join(root, file))
    
    if len(config_files) == 0:
        print("No config files found")
    else:
        print(f"Found {len(config_files)} config files")
        for file in config_files:
            print(f" - {file}")
    
    return config_files

def move_file_and_cleanup(src, dest):
    os.makedirs(os.path.dirname(dest), exist_ok=True)
    os.rename(src, dest)
    src_parent_dir = os.path.dirname(src)
    print(f'src_parent_dir: {src_parent_dir}')
    ## check if the parent dir is empty
    if len(os.listdir(src_parent_dir)) == 0:
        os.rmdir(src_parent_dir)
        print(f'{src_parent_dir} is empty and removed')

def main():
    
    ## read CLi arg gpu_list
    parser = argparse.ArgumentParser()
    parser.add_argument('--gpu_list', type=str, required=True)
    parser.add_argument('--needed_ram', type=str, required=True)
    parser.add_argument('--config_dir', type=str, required=True)
    args = parser.parse_args()
    
    gpu_list = [int(gpu) for gpu in args.gpu_list.split(',')]
    needed_ram = int(args.needed_ram)
    config_dir_path = os.path.join(start_queue_folder, args.config_dir)
    
    process_dict = {}
    gpus_starting = {}
    
    while True:
        free_gpu = get_free_gpu(gpu_list, needed_ram)
        config_files = find_config_files(config_dir_path)
        
        if free_gpu is not None and len(config_files) > 0:
            config_file = config_files[0]
            
            ## Move the config file to the running folder
            running_config_file = config_file.replace(start_queue_folder, running_folder)
            move_file_and_cleanup(config_file, running_config_file)
            
            config_for_subprocess = running_config_file.replace('configs/', '')
            print(f'Starting the job with {config_for_subprocess} on GPU {free_gpu}')
            command = f"python run.py --yml {config_for_subprocess} --gpu_list {free_gpu}"
            process = subprocess.Popen(command, shell=True)
            print(f'Process with pid {process.pid} started')
            process_dict[config_for_subprocess] = process
            
            gpus_starting[free_gpu] = START_COUNTER
            gpu_list.remove(free_gpu)
            
                
        # Check if any of the processes have finished
        print(f'Checking processes with pids {[p.pid for p in process_dict.values()]}')
        for processing_config in list(process_dict.keys()):
            process = process_dict[processing_config]
            if process.poll() is not None:
                process_dict.pop(processing_config)
                print(f"Process with {process.pid} finished")
                
                ## Move the config file to the finished folder
                running_config_file = os.path.join('configs', processing_config)
                finished_config_file = running_config_file.replace(running_folder, finished_folder)
                move_file_and_cleanup(running_config_file, finished_config_file)
        
        time.sleep(SLEEP_SECONDS)
        
        ## decrease the counter for starting gpus
        for gpu in list(gpus_starting.keys()):
            gpus_starting[gpu] -= 1
            if gpus_starting[gpu] == 0:
                gpus_starting.pop(gpu)
                gpu_list.append(gpu)


if __name__ == "__main__":
    main()
