# SPEAR: Receiver-to-Receiver Acoustic Neural Warping Field Supplementary Material

## Folder Structure

`examples/`: Folder containing examples of generated audios

`configs/`: Folder containing training hyperparameters in yaml file

`data/`: Folder containing code for data generation and data loading

`models/`: Folder containing code for model implementations

`Loss.py`: Implementation for training loss functions

`test.py`: Implementation for evaluation metrics

`train.py`: Implementation for model training

## Reproduce Results

### Step 1: Generate synthetic data
To generate the synthetic train and test data using Pyroomacoustic, run the following command

```python
python data/R2RGenerator.py train
python data/R2RGenerator.py test
```

### Step 2: Train
To train a model, run 
```shell
python train.py configs/Hyperparameter.yaml
```

### Step 3: Test
To obtain a model's test performance metric, uncomment corresponding lines in `test.py` and run the file. 
```shell
python test.py
```

## Generated examples
We provide examples of generated audios in `examples` folder
- `examples/{scene_name}/{sound_source_name}/ref.wav`: simulated reference position audio
- `examples/{scene_name}/{sound_source_name}/tgt.wav`: simulated target position audio
- `examples/{scene_name}/{sound_source_name}/tgt_predicted.wav`: warped audio generated by the *SPEAR* model

