# SSIF

This repository contains the implementation for SSIF introduced in the following paper:

SSIF: Physics-Inspired Implicit Representations for Spatial-Spectral Image Super-Resolution (NeurIPS 2024 # 2521 )

### Environment
- Python 3
- torch
- TensorboardX
- wandb, yaml, numpy, tqdm, imageio, skimage, pandas, timm, scipy


## Reproducing Experiments

### Data

`mkdir load` for putting the dataset folders. Download our processed dataset from link: ``

*In order not to violate the double-blind rule, we will release our processed data after the paper is accepted*


### Running the code

**0. Preliminaries**

- For `train.py` or `test.py`, use `--gpu [GPU]` to specify the GPUs (e.g. `--gpu 0` or `--gpu 0,1`).

- For `train.py`, by default, the save folder is at `save/_[CONFIG_NAME]`. We can use `--name` to specify a name if needed.

- For dataset args in configs, `cache: in_memory` denotes pre-loading into memory, `cache: bin` denotes creating binary files (in a sibling folder) for the first time, `cache: none` denotes direct loading. We can modify it according to the hardware resources before running the training scripts.

- The model config file with name `**_gaussian_gaussian_**`  is SSIF-RF-GS variant; `**_uniform_uniform_**` is SSIF-RF-US variant; `**_gaussian_fix_**` is SSIF-RF-GF variant; `**_uniform_fix_**` is SSIF-RF-UF variant; `**_m_**` is SSIF-M variant.

- For using EDSR or RDN as image encoder, replace ` encoder_spec:name:swinir` with `encoder_spec:name:edsr` or `encoder_spec:name:rdn`  in the model config file.

- For using LIIF  as pixel feature decoder, replace ` model:name:ciaosr` with `model:name:liif`  in the model config file.

**1. CAVE experiments**

**Train**: `python train.py --config config/train-cave/train_swinir-ciaosr-band_rb_mlp-U16_gaussian_gaussian_img_band_dot.yaml` 

**Test**: `python test_batch.py --config config/test-cave/test_ssif.yaml --model [MODEL_PATH] --scale_list [SPATIAL_FACTOR] --num_band_list [BAND_NUMBER]`

**2. Pavia Centra experiments**

**Train**: `python train_multi_data.py --config config/train-pavia_centra/train_swinir-ciaosr_band_rb_mlp_G256_H512-U64_gaussian_gaussian-img_band_dot.yaml`.

**Test**: `python test_batch.py --config config/test-pavia_centra/test_ssif.yaml --model [MODEL_PATH] --scale_list [SPATIAL_FACTOR] --num_band_list [BAND_NUMBER]`
