# MLE + Inference Code

This folder contains code to reproduce our results on the favorita dataset.

## Requirements

1. Please install tensorflow, tensorflow_probability, numpy , scipy, scikit-learn, tqdm, tabulate , absl


## Datasets

`cd datasets`

`bash download.sh`


## Python Scripts

1. In order run code for MLE method:

`python train.py --dataset=favorita --out_dim=7 --inference_class=MixZeroNBinomPareto --loss_function=mix_znbp_mle --error_metric=MAE`

Here the `error_metric` takes values in [MSE, MAPE, MAE, QUANTILE] denoting the target error metric. When using QUANTILE, one needs to add a quantile to prediction config (look at line 37 in train.py). The quantile also needs to be suplied as a flag `--quantile=0.10`.


2. In order run code for ERM method:

`python train.py --dataset-favorita --out_dim=1 --loss_function=mse --error_metric=MSE` 

Here the `loss_function` is set as mse, mae, mape for `error_metric` MSE, MAE, MAPE respectively. 

### License

This code is only meant for the reviewers of ICLR 2022. Please do not distribute under any circumstances.