# Core Sentiment Inventory (CSI) - Experiment Files

This repository contains all necessary files for running and analyzing experiments using the Core Sentiment Inventory (CSI) in both English and Chinese. CSI is a novel tool designed to evaluate sentiment tendencies in large language models (LLMs) across optimism, pessimism, and neutrality. Below is an overview of the available files and their respective purposes.

## Files Overview

### 1. `chn_CSI.jsonl`
- This file contains the **Chinese CSI dataset** in JSON Lines format. It includes a curated list of stimuli words used to evaluate the sentiment tendencies of models in Chinese.

### 2. `eng_CSI.jsonl`
- This file contains the **English CSI dataset** in JSON Lines format. It includes a curated list of stimuli words used to evaluate the sentiment tendencies of models in English.

### 3. `exp_results/`
- This folder contains **experimental results** generated from various tests conducted on different language models using both the English and Chinese CSI datasets.

### 4. `associate.py`
- This is the **main experiment script**. It handles the core tasks, such as associating the stimuli words with sentiment scores and generating the final results for analysis. This script is essential for the primary CSI evaluations.

### 5. `story_generation.py`
- This script is responsible for **generating stories** based on selected words from the CSI dataset. It helps create scenarios that can be used to further analyze the models' sentiment inclinations in narrative contexts.

### 6. `prompt.py`
- This file includes  all prompt templates we used

### 7. `senti_score_chn.py`
- This is the **Chinese and English sentiment scoring script**, which is used to assign sentiment scores to generated stories or other inputs in Chinese. It complements the English sentiment analysis tools by providing evaluation for Chinese content.

## How to Run the Main Experiment

1. Ensure you have all necessary dependencies installed, and use you openAI api key. 
2. Execute the `associate.py` script to run the main CSI evaluations across your chosen language models.
   ```bash
   python associate.py