from prompt import eng_sentiment_prompt_v2, chn_sentiment_prompt_v2
from tqdm import tqdm
import os
from datetime import datetime
import csv
import pandas as pd
import random
from openai import OpenAI
import re
import json


# Set up OpenAI client
openai_api_key = "EMPTY"
openai_api_base = "http://localhost:8000/v1"

client = OpenAI(
    api_key=openai_api_key,
    base_url=openai_api_base,
)

# Function to get LLM response
def get_llm_response(inputs, model="gpt-4o", temp=0, seed=1):
    response = client.chat.completions.create(
        model=model,
        messages=inputs,
        temperature=temp,
        seed=seed
    )
    res = response.choices[0].message.content
    return res

# Seed words generation


experiment_folder = ''
lang = ''





stories_folder = os.path.join(experiment_folder, "stories")



if lang == 'Chinese':
    instruction = chn_sentiment_prompt_v2
else:
    instruction = eng_sentiment_prompt_v2

score_folder = os.path.join(experiment_folder, "scores_v2")
os.makedirs(score_folder, exist_ok=True)

# Iterate through all .txt files in the directory
for filename in tqdm(os.listdir(stories_folder)):
    if filename.endswith('.txt'):
        file_path = os.path.join(stories_folder, filename)
        degree = filename.split('-')[0]
        # Read the content of the file
        with open(file_path, 'r', encoding='utf-8') as file:
            story = file.read()
            
        content = instruction + story
        inputs = [{"role": "user", "content": content}]

        # Save prompt used in the story
        
        # Save the story to the corresponding file
        result = get_llm_response(inputs, model="qwen2-72b-instruct")
        score_file_path = os.path.join(score_folder, f'score_{filename}')
        
        with open(score_file_path, "a", encoding='utf-8') as response_file:
            response_file.write(f'{result}\n')
        
        # Get the response from LLM




