import numpy as np
from typing import Optional

class Model:
    """
    Model:
    dX_t = f(X_t, theta)dt + g(X_t, theta)dW_t

    :param dim: int, dimension of the SDE system
    :param m: int, dimension of the standard Wiener process
    """
    def __init__(self,
                dim: int,
                m: int,
                has_exact_density: bool = False):
        self._dim = dim
        self._m = m
        self._has_exact_density = has_exact_density
        self._params: Optional[np.ndarry] = None
  
    
    @property
    def params(self) -> np.ndarray:
        """ Access the params """
        return self._params
    
    @params.setter
    def params(self, vals: np.ndarray):
        """ Set parameters, used by fitter to move through param space """
        self._params = vals

    @property
    def dim(self) -> int:
        """ Access the dimension of the SDE system (state X_t) """
        return self._dim

    @property
    def noise_dim(self) -> int:
        """ Access the dimension of the Wiener process """
        return self._m

        