## Installation

```bash
conda create -n synflow python=3.10
conda activate synflow
pip install -e . --find-links https://data.pyg.org/whl/torch-2.1.2+cu121.html
pip uninstall torch-sparse torch-scatter torch-cluster
pip install torch-sparse torch-scatter torch-cluster -f https://data.pyg.org/whl/torch-2.5.1+cu124.html
```

## Generating scripts

Modify `cmd` in `scripts/generate_scripts.py` so it matches your server needs. Note that the synflownet takes a lot of memory and I was unable to run it on 32GB A100 GPU. I run it on CPU instead, but it takes a lot of time (synflownet_128 setting will probably take more than a week for a single run...).

```bash
cd scripts
python generate_scripts.py
```

### Running the code
You can simply type `sh scripts/run_all.sh` on the server to run all the jobs. 

### The results

Importantly, the results will be saved under 'logs/setup_rgfn_synflow_128_task_{task}reinforce_False_action_embedding_True_temp_{temp}_seed_{seed}/'. Two interesting files are `paths.csv` and `final_paths.csv`. They should be sent to me, organized by the task and the seed (e.g. in directory `{task}/{seed}`). 

