from calibration_schemes.AbstractCalibration import Calibration
from calibration_schemes.PrivilegedConformalPrediction import PrivilegedConformalPrediction
from data_utils.data_corruption.data_corruption_masker import DataCorruptionMasker
from data_utils.data_scaler import DataScaler


class OracleFullyWeightedCalibration(PrivilegedConformalPrediction):

    def __init__(self, base_y_calibration: Calibration, alpha: float, dataset_name: str, data_scaler: DataScaler,
                 data_masker: DataCorruptionMasker):
        super().__init__(base_y_calibration, alpha, dataset_name, data_scaler, data_masker)

    @property
    def name(self):
        return f"oracle_w2_{self.base_y_calibration.name}"
