import abc

import torch


class ClusteringMethod(abc.ABC):
    def __init__(self):
        pass

    @abc.abstractmethod
    def fit(self, x: torch.Tensor, y: torch.Tensor, more_features: torch.Tensor = None, **kwargs):
        pass

    def calibrate(self, x: torch.Tensor, **kwargs):
        pass

    @abc.abstractmethod
    def predict_cluster(self, x):
        pass

    @property
    @abc.abstractmethod
    def name(self):
        pass
