import numpy as np
import torch
from numpy.random import choice

def sample_from_pdf(density, grid, device):
    sampled_errors = []
    if torch.is_tensor(density):
        density = density.detach().cpu().numpy()
    for i in range(len(density)):
        normalized_density = density[i].copy()
        normalized_density /= normalized_density.sum()
        # normalized_density = normalized_density.astype(np.float32)
        pde = choice(grid, 1, p=normalized_density)
        sampled_errors += [pde.item()]
    return torch.Tensor(sampled_errors).to(device)