import numpy as np
import torch


def construct_histogram(y1: torch.Tensor, min_bin_size: int = 50):
    initial_bin_width = (y1.max().item() - y1.min().item()) / min_bin_size
    bin_edges_idx = list(range(0, y1.shape[0] // 2, min_bin_size)) + list \
        (reversed(range(y1.shape[0] - 1, y1.shape[0] // 2, -min_bin_size)))
    y1_sorted = y1.sort().values
    i = 0
    while True:
        if i >= len(bin_edges_idx) - 2:
            break
        curr_lower = y1_sorted[bin_edges_idx[i]]
        next_upper = y1_sorted[bin_edges_idx[i + 2]]
        if (next_upper - curr_lower) < initial_bin_width:
            bin_edges_idx.pop(i + 1)
        else:
            i += 1
    bin_edges = [-np.inf] + [y1_sorted[i].item() for i in bin_edges_idx] + [np.inf]
    return bin_edges
    # plt.hist(y1.cpu().numpy(), bins=bin_edges)
    # plt.show()
