# Readme

This code belongs to the paper 'Neural Sinkhorn Flow Model'. It contains implementations for the  CIFAR-10 experiments.

## Requirements

We tested the code with python 3.10.9 and the following package versions:

- pytorch 1.13.1
- torchvision 0.14.1
- geomloss 0.2.5
- pillow 9.4.0
- pytorch-fid 0.3.0
- tqdm 4.64.1

Usually, the code is also compatible with some other versions of the corresponding packages.

## Introduction

- Build trajectory pool:

Repeatedly running `main_sinkhorn.py`

```
python main_sinkhron.py --dataset CIFAR10 --batch_size 128 --T 100 
```

- Velocity field matching

```
python main_minibatchOT.py
```

- Image generation

```
python evaluator.py
```

