# Python implementation of the few-shot image classification experiments in "How does the Task Landscape Affect MAML?" paper

Note: The file MAML_Landscape.ipynb contains the code for all numerical simulations besides the Omniglot and FS-CIFAR100 experiments.

The rest of the repository is an adaptation of the repository from the ["How to train your MAML"](https://arxiv.org/abs/1810.09502) paper by Antoniou et al., which can be accessed [here](https://github.com/AntreasAntoniou/HowToTrainYourMAMLPytorch).

Citation:
@article{antoniou2018train,
  title={How to train your maml},
  author={Antoniou, Antreas and Edwards, Harrison and Storkey, Amos},
  journal={arXiv preprint arXiv:1810.09502},
  year={2018}
}

The following is an adapted version of the README from the original ["How to train your MAML" repository](https://github.com/AntreasAntoniou/HowToTrainYourMAMLPytorch).

By using this codebase you agree to the terms
and conditions in the [LICENSE](https://github.com/AntreasAntoniou/HowToTrainYourMAMLPytorch/blob/master/LICENSE) file.

## Installation

The code uses Pytorch to run, along with many other smaller packages. To take care of everything at once, we recommend
using the conda package management library. More specifically,
[miniconda3](https://repo.continuum.io/miniconda/Miniconda3-latest-Linux-x86_64.sh), as it is lightweight and fast to install.
If you have an existing miniconda3 installation please start at step 3.
If you want to  install both conda and the required packages, please run:
 1. ```wget https://repo.continuum.io/miniconda/Miniconda3-latest-Linux-x86_64.sh```
 2. Go through the installation.
 3. Activate conda
 4. conda create -n meta_learning_pytorch_env python=3.6.
 5. conda activate meta_learning_pytorch_env
 6. At this stage you need to choose which version of pytorch you need by visiting [here](https://pytorch.org/get-started/locally/)
 7. Choose and install the pytorch variant of your choice using the conda commands.
 8. Then run ```bash install.sh```

To execute an installation script simply run:
```bash <installation_file_name>```

To activate your conda installations simply run:
```conda activate```

## Datasets

The Omniglot dataset can be downloaded from https://github.com/brendenlake/omniglot/tree/master/python, specifically images_background.zip and images_evaluation.zip must be downloaded. Once unzipped, these folders must be placed in /datasets, following the analogous structure as in the ["How to train your MAML" repository](https://github.com/AntreasAntoniou/HowToTrainYourMAMLPytorch/).
The FS-CIFAR100 dataset can be downloaded from https://www.cs.toronto.edu/~kriz/cifar.html (choose the CIFAR100 python version) and follow the same procedure as for Omniglot. 

## Overview of code:

- datasets folder: Contains the dataset files (once added) and folders containing the images in a structure readable by the
custom data provider.
- experiments_config: Contains configuration files for each and every experiment listed in the experiments script folder.
- experiment_scripts: Contains scripts that can reproduce every results in the paper. The results from Table 1 can be reproduced by running
```bash OMNI* <GPU_ID>```
and the results for Table 2 can be reproduced by running
```bash CIFAR* <GPU_ID>```
IMPORTANT: In order to run the expriments for Table 1, you must rename data_OMNI.py data.py: cp data_OMNI.py data.py
           Likewise, in order to run the experiments for Table 2, you must execute: cp data_CIFAR.py data.py

- script_generation_tools: Contains scripts and template files for the automatic generation of experiment scripts.
- utils: Contains utilities for dataset extraction, parser argument extraction and storage of statistics and others.
- data*.py: Contains the data providers for the few shot meta learning task generation. The data provider is agnostic
to dataset, which means it can be used with any dataset. Most importantly, it can only scan and use datasets when they
are presented in a specific format. The two formats that the data provider can read are:
1. A folder structure where the top level folders are the classes and the contained images of each folders, the images
of that class, as illustrated below:
```
Dataset
    ||______
    |       |
 class_0 class_1 ... class_N
    |       |___________________
    |                           |
samples for class_0    samples for class_1
```
In this case the data provider will split the data into 3 sets, train, val and test using the train_val_test_split
variable found in the experiment_config files. However, in the case where you have a pre-split dataset, such
as mini_imagenet, you can instead use:
2. A folder structure where the higher level folders indicate the set (i.e. train, val, test), the mid level folders
(i.e. the folders within a particular set) indicate the class and the images within each class indicate the images of
that class.
```
Dataset
    ||
 ___||_________
|       |     |
Train   Val  Test
|_________________________
    |       |            |
 class_0 class_1 ... class_N
    |       |___________________
    |                           |
samples for class_0    samples for class_1
```
- experiment_builder.py: Builds an experiment ready to train and evaluate your meta learning models. It supports automatic
checkpoining and even fault-tolerant code. If your script is killed for whatever reason, you can simply rerun the script.
It will find where it was before it was killed and continue onwards towards convergence!

- few_shot_learning_system.py: Contains the meta_learning_system class which is where most of MAML and TR-MAML are actually
implemented. It takes care of inner and outer loop optimization, checkpointing, reloading and statistics generation, as
well as setting the rng seeds in pytorch.

- meta_neural_network_architectures: Contains new pytorch layers which are capable of utilizing either internal
parameter or externally passed parameters.

- train_maml_system.py: A very minimal script that combines the data provider with a meta learning system and sends them
 to the experiment builder to run an experiment. Also takes care of automated extraction of data if they are not
 available in a folder structure.

# Running an experiment
To run an experiment from the paper on Omniglot:
1. Activate your conda environment ```conda activate pytorch_meta_learning_env```
2. cd experiment_scripts
3. Find which experiment you want to run.
4. ```bash experiment_script.sh gpu_ids_separated_by_spaces```


 
