import numpy as np
# import math
import matplotlib.pyplot as plt


plt.rc('font',family='Times New Roman')
plt.rcParams['xtick.direction'] = 'in'#将x周的刻度线方向设置向内
plt.rcParams['ytick.direction'] = 'in'#将y轴的刻度方向设置向内
plt.rcParams['mathtext.default'] = 'it'




mse_constrained=np.asarray([0.009457407,0.001517407,0.000481852,0.000247778,0.000112963])
mse_unconstrain=np.asarray([0.025706667,0.005046667,0.002731852,0.00037,0.000147037])
mse_SMNN=np.asarray([0.024452963,0.003803704,0.001631852,0.00059963,0.000480741])
param_constrained=np.asarray([101,329,881,1709,3297])
param_unconstrain=np.asarray([101,329,881,1709,3297])
param_SMNN=np.asarray([113,337,901,1841,3341])

mse_constrained=np.log10(mse_constrained)
mse_unconstrain=np.log10(mse_unconstrain)
mse_SMNN=np.log10(mse_SMNN)
param_constrained=np.log10(param_constrained)
param_unconstrain=np.log10(param_unconstrain)
param_SMNN=np.log10(param_SMNN)

timeLine=list(np.arange(0,5))
plt.figure(figsize=(6,4),dpi=100)
plt.plot(param_SMNN,mse_SMNN,c='olivedrab',linewidth=2,linestyle='--',marker='o',label='SMNN',markerfacecolor='none',markersize=9)
plt.plot(param_unconstrain,mse_unconstrain,c='steelblue',linewidth=2,linestyle='--',label='Unconstrained',marker='o',markerfacecolor='none',markersize=9)
plt.plot(param_constrained,mse_constrained,c='darkred',linewidth=2,linestyle='--',label='Constrained (Ours)',marker='o',markerfacecolor='none',markersize=9)
plt.ylabel('Log Mean MSE',fontsize=13)
plt.xlabel('Number of Parameters',fontsize=13)
plt.xlim(1.85,3.7)
plt.ylim(-4.2,-1.2)
plt.yticks(ticks=[-2,-3,-4],labels=['$\mathit{10}^{-2}$','$\mathit{10}^{-3}$','$\mathit{10}^{-4}$'])
plt.xticks(ticks=[2,2.5,3.0,3.5],labels=['$\mathit{10}^{2}$','$\mathit{10}^{2.5}$','$\mathit{10}^{3}$','$\mathit{10}^{3.5}$'])
plt.grid()
plt.legend(fontsize=13)
plt.savefig('figures/compare_three.pdf',bbox_inches='tight')
plt.show()