# Shaping Monotonic Neural Networks with Constrained Learning
This repository contains the source code to reproduce the results in the submitted paper. 

In this repository, each folder contains an independent experiment presented in the paper. Among them, the folders `compas`, `blogfeedback`, `loandefaulter`, `autoMPG`, and `heartdisease` are the codes for the experimental results in `Table 1` and `Table 2`. The folder `2Dexample` corresponds to the results in `Figure 1`, while the folder `frequencycontrol` corresponds to the results in `Figure 2` and `Figure 3`.

## A quick start to use this code
1. To train, run the command:
```
# E.g., train on compas dataset.
cd compas
python main.py --batch_size 256 --lr 5e-4 --epochs 500
``` 

2. To test, run the command:
```
# E.g., test on the compas dataset.
cd compas
python test.py
```
To run other experiments, please change the dir and use similar commands.

# Main results
<center>
    <img style="border-radius: 0.3125em;
    box-shadow: 0 2px 4px 0 rgba(34,36,38,.12),0 2px 10px 0 rgba(34,36,38,.08);" 
    src="figures/Figure1.png">
    <br>
    <div style="color:orange; border-bottom: 1px solid #d9d9d9;
    display: inline-block;
    color: #999;
    padding: 2px;">Figure 1. Comparison of unconstrained network, SMNN, and our method on a 2D example.</div>
</center>



<center>
    <img style="border-radius: 0.3125em;
    box-shadow: 0 2px 4px 0 rgba(34,36,38,.12),0 2px 10px 0 rgba(34,36,38,.08);" 
    src="figures/Table1.png">
    <br>
    <div style="color:orange; border-bottom: 1px solid #d9d9d9;
    display: inline-block;
    color: #999;
    padding: 2px;">Table 1. Comparison of our method with other methods</div>
</center>

<center>
    <img style="border-radius: 0.3125em;
    box-shadow: 0 2px 4px 0 rgba(34,36,38,.12),0 2px 10px 0 rgba(34,36,38,.08);" 
    src="figures/Table2.png" width="300">
    <br>
    <div style="color:orange; border-bottom: 1px solid #d9d9d9;
    display: inline-block;
    color: #999;
    padding: 2px;">Table 2. Comparison of our method with other methods</div>
</center>

<center>
    <img style="border-radius: 0.3125em;
    box-shadow: 0 2px 4px 0 rgba(34,36,38,.12),0 2px 10px 0 rgba(34,36,38,.08);" 
    src="figures/Figure2.png">
    <br>
    <div style="color:orange; border-bottom: 1px solid #d9d9d9;
    display: inline-block;
    color: #999;
    padding: 2px;">Figure 2. Comparison of the control trajectories and objective costs on a real-world frequency control system. The number inside the figure denotes the objective cost.</div>
</center>
