import os
import random
import sys
import numpy as np
import torch
from pickle import load

from torch.utils.data import DataLoader
from sklearn.metrics import accuracy_score

from autompg_loader import *

def test():
    data_test_path='test.csv'
    test_dataset=AutompgdataLoader(csv_path=data_test_path)
    print("Testing dataset size:", len(test_dataset))

    test_loader=DataLoader(test_dataset,batch_size=len(test_dataset),shuffle=True,drop_last=False)

    model=torch.load("model_2.pth")

    param_amout = 0
    for p in model.named_parameters():
        param_amout += p[1].numel()
    print('The total param amount:', param_amout)

    criterion=torch.nn.MSELoss()
    ## make prediction
    with torch.no_grad():
        for j,(x,y) in enumerate(test_loader):
            pred_y=model(x)

            load_scaler = load(open(f'{"./"}{"scaler.pkl"}', 'rb'))
            pred_y = pred_y * (load_scaler.data_max_[0] - load_scaler.data_min_[0]) + load_scaler.data_min_[0]
            true_y = y * (load_scaler.data_max_[0] - load_scaler.data_min_[0]) + load_scaler.data_min_[0]
            mse = criterion(pred_y, true_y)

    print('Test accuracy: {}'.format(mse))



if __name__=="__main__":
    test()