import numpy as np
from mat4py import loadmat
import torch
import torch.nn.functional as F
import matplotlib.pyplot as plt

from env import Frequency


## Load the network data
data=loadmat('data/IEEE_39bus_Kron.mat')
K_EN=data['Kron_39bus']['K']
K_EN=np.asarray(K_EN,dtype=np.float32)

H=data['Kron_39bus']['H']
H=np.asarray(H,dtype=np.float32)

Damp=data['Kron_39bus']['D']
Damp=np.asarray(Damp,dtype=np.float32)

omega_R=data['Kron_39bus']['omega_R']

A_EN=data['Kron_39bus']['A']
A_EN=np.asarray(A_EN,dtype=np.float32)

gamma=data['Kron_39bus']['gamma']
gamma=np.asarray(gamma,dtype=np.float32)

## The network parameter
dim_action=10
dim_state=2*dim_action
delta_t=0.01
M=H.reshape(dim_action)*2/omega_R*2*np.pi
D=np.zeros(dim_action,dtype=np.float32)
D[0]=2*590/100
D[1:8]=2*865/100
D[8:10]=2*911/100
D=D/omega_R*2*np.pi
F=K_EN
Penalty_action=0.02*0.2
Pm = np.array([[-0.19983394, -0.25653884, -0.25191885, -0.10242008, -0.34510365,
         0.23206371,  0.4404325 ,  0.5896664 ,  0.26257738, -0.36892462]],dtype = np.float32)

max_action = np.array([[0.19606592, 0.2190382 , 0.22375287, 0.0975513 , 0.29071101,
        0.22091283, 0.38759459, 0.56512538, 0.24151538, 0.29821917]],dtype = np.float32)

equilibrium_init = np.array([[ -0.05420687, -0.07780334, -0.07351729, -0.05827823, -0.09359571,
        -0.02447385, -0.00783582,  0.00259523, -0.0162409 , -0.06477749,
         0.        ,  0.        ,  0.        ,  0.        ,  0.        ,
         0.        ,  0.        ,  0.        ,  0.        ,  0.       ]],dtype = np.float32)

env=Frequency(Pm,M,D,F,delta_t,max_action,dim_action,Penalty_action)

## The linear drop control
def np_relu(x):
    return np.maximum(0,x)

def Action_linear(state,linear_coff,env):
    action_nonconstrain=(state@env.select_w)*linear_coff
    action=env.max_action-np_relu(env.max_action-action_nonconstrain)+np_relu(-env.max_action-action_nonconstrain)
    return action

linear_coff=np.array([[ 2.2347659,   2.720281 ,   2.4595585,  43.59709  ,   5.7675405,
          2.3880444, 156.02136  ,  12.0558605,   2.8042254,  25.922562  ]], dtype=np.float32)
action_units=dim_action

#################################################################################
# Apply the control
Trajectory_Linear=[]
initial_state1=np.random.uniform(-0.1,0.1,(1,dim_action))*1
initial_state2=np.random.uniform(-0.2,0.2,(1,dim_action))*1
s_concate=np.hstack((initial_state1,initial_state2)).astype(np.float32)

init_state=equilibrium_init+s_concate
s=init_state
env.set_state(s)
Trajectory_Linear.append(s)
SimulationLength=400
Record_u_Linear=[]
Record_Loss_Linear=[]
Loss_Linear=0

for i in range(SimulationLength):
    u=np.squeeze(Action_linear(s,linear_coff,env))
    next_s,r=env.step(u,Pm)
    Loss_Linear+=r
    s=next_s

    ## record the control
    Trajectory_Linear.append(s)
    Record_u_Linear.append(u)
    Record_Loss_Linear.append(np.squeeze(r))

Trajectory_Linear=np.squeeze(np.asarray(Trajectory_Linear))
plt.figure(figsize=(11,8),dpi=100)
TimeRecord=np.arange(1,SimulationLength+1)
TimeRecord=env.delta_t*TimeRecord

plt.subplot(2,2,1)
plt.plot(TimeRecord,Record_Loss_Linear)
plt.xlabel('time (s)')
plt.ylabel('Loss')

plt.subplot(2,2,2)
plt.plot(TimeRecord,Record_u_Linear)
plt.xlabel('time (s)')
plt.ylabel('Action')

plt.subplot(2,2,3)
TimeRecord=np.arange(1,SimulationLength+2)
TimeRecord=env.delta_t*TimeRecord
plt.plot(TimeRecord,Trajectory_Linear[:,0:action_units])
plt.xlabel('time (s)')
plt.ylabel('delta (rad)')

plt.subplot(2,2,4)
plt.plot(TimeRecord,Trajectory_Linear[:,action_units:action_units*2])
plt.xlabel('time (s)')
plt.ylabel('w (p.u.)')
plt.show()




