import numpy as np
import matplotlib.pyplot as plt

plt.rc('font',family='Times New Roman')
plt.rcParams['xtick.direction'] = 'in'#将x周的刻度线方向设置向内
plt.rcParams['ytick.direction'] = 'in'#将y轴的刻度方向设置向内
plt.rcParams['mathtext.default'] = 'it'
# plt.rcParams['axes.facecolor'] = 'lightgrey'

action_cons_learn=np.load('action_constrained_learn.npy')
action_SMNN=np.load('action_SMNN.npy')
action_one_layer=np.load('action_one_layer.npy')

trajec_cons_learn=np.load('trajectory_constrained_learn.npy')
trajec_SMNN=np.load('trajectory_SMNN.npy')
trajec_one_layer=np.load('trajectory_one_layer.npy')

SimulationLength=700
delta_t=0.01
action_units=10

TimeRecord=np.arange(1,SimulationLength+1)
TimeRecord2=np.arange(1,SimulationLength+2)
TimeRecord=delta_t*TimeRecord
TimeRecord2=delta_t*TimeRecord2

plt.figure(figsize=(4.5,10),dpi=100)
plt.subplot(3,1,1)
# for i in range(10):
plt.plot(TimeRecord2,trajec_one_layer[:,action_units:],linewidth=2)
plt.ylim(-0.02,0.02)
plt.xlim(0,7)
plt.yticks(np.arange(-0.02, 0.02, step=0.01))
# plt.yticks(ticks=[-2,-1,0,1,2],labels=[-2,-1,0,1,2])
plt.grid(ls='--')
# plt.xlabel('time (s)')
plt.text(1.3,0.0105,'Obj. Cost=0.038 p.u.',fontsize=23)
ax = plt.gca()
plt.ylabel('Frequency $w$ (rad/s)',fontsize=16)
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')

plt.subplot(3,1,2)
for i in range(10):
    plt.plot(TimeRecord,action_one_layer[:,i],linewidth=2,label='gen {}'.format(i+1))
plt.ylim(-0.21,0.21)
plt.xlim(0,7)
plt.grid(ls='--')
# plt.xlabel('time (s)')
plt.ylabel('Action $u$',fontsize=16)
plt.legend(fontsize=10,ncol=3,loc='lower right')

plt.subplot(3,1,3)
plt.plot(TimeRecord2,trajec_one_layer[:,:action_units],linewidth=2)
plt.ylim(-0.1,0.045)
plt.xlim(0,7)
plt.grid(ls='--')
plt.xlabel('time (s)',fontsize=16)
plt.yticks(np.arange(-0.1, 0.04, step=0.05))
ax = plt.gca()
plt.ylabel('Phase angle $\lambda$',fontsize=16)
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')
plt.savefig('figures/action_frequency_one_layer.pdf',bbox_inches='tight')
plt.show()

#################################################################
plt.figure(figsize=(4.5,10),dpi=100)
plt.subplot(3,1,1)
plt.plot(TimeRecord2,trajec_SMNN[:,action_units:],linewidth=2)
plt.ylim(-0.02,0.02)
plt.xlim(0,7)
plt.grid(ls='--')
plt.ylabel('Frequency $w$ (rad/s)',fontsize=16)
plt.yticks(np.arange(-0.02, 0.02, step=0.01))
# plt.xlabel('time (s)')
# plt.ylabel('Frequency $w$ (rad/s)')
plt.text(1.3,0.0105,'Obj. Cost=0.048 p.u.',fontsize=23)
ax = plt.gca()
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')

plt.subplot(3,1,2)
for i in range(10):
    plt.plot(TimeRecord,action_SMNN[:,i],linewidth=2,label='gen {}'.format(i+1))
plt.ylim(-0.21,0.21)
plt.xlim(0,7)
plt.grid(ls='--')
# plt.xlabel('time (s)')
# plt.ylabel('Action')
plt.ylabel('Action $u$',fontsize=16)
plt.legend(fontsize=10,ncol=3,loc='lower right')

plt.subplot(3,1,3)
plt.plot(TimeRecord2,trajec_SMNN[:,:action_units],linewidth=2)
ax = plt.gca()
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')
plt.ylim(-0.1,0.045)
plt.xlim(0,7)
plt.grid(ls='--')
plt.xlabel('time (s)',fontsize=16)
plt.ylabel('Phase angle $\lambda$',fontsize=16)
plt.yticks(np.arange(-0.1, 0.04, step=0.05))
# plt.ylabel('$\lambda$')
plt.savefig('figures/action_frequency_SMNN.pdf',bbox_inches='tight')
plt.show()

#################################################################
plt.figure(figsize=(4.5,10),dpi=100)
plt.subplot(3,1,1)
plt.plot(TimeRecord2,trajec_cons_learn[:,action_units:],linewidth=2)
plt.ylim(-0.02,0.02)
plt.xlim(0,7)
plt.grid(ls='--')
# plt.xlabel('time (s)')
# plt.ylabel('Frequency $w$ (rad/s)')
plt.yticks(np.arange(-0.02, 0.02, step=0.01))
plt.text(1.3,0.0105,'Obj. Cost=0.036 p.u.',fontsize=23)
ax = plt.gca()
plt.ylabel('Frequency $w$ (rad/s)',fontsize=16)
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')

plt.subplot(3,1,2)
for i in range(10):
    plt.plot(TimeRecord,action_cons_learn[:,i],linewidth=2,label='gen {}'.format(i+1))
plt.ylim(-0.21,0.21)
plt.xlim(0,7)
plt.grid(ls='--')
# plt.xlabel('time (s)')
# plt.ylabel('Action')
plt.ylabel('Action $u$',fontsize=16)
plt.legend(fontsize=10,ncol=3,loc='lower right')

plt.subplot(3,1,3)
plt.plot(TimeRecord2,trajec_cons_learn[:,:action_units],linewidth=2)
plt.ylim(-0.1,0.045)
plt.xlim(0,7)
plt.grid(ls='--')
plt.xlabel('time (s)',fontsize=16)
# plt.ylabel('$\lambda$')
ax = plt.gca()
plt.yticks(np.arange(-0.1, 0.04, step=0.05))
plt.ylabel('Phase angle $\lambda$',fontsize=16)
ax.ticklabel_format(style='sci', scilimits=(-1,1), axis='y')
plt.savefig('figures/action_frequency_constrained_learn.pdf',bbox_inches='tight')
plt.show()