import numpy as np
import matplotlib.pyplot as plt

plt.rc('font',family='Times New Roman')
plt.rcParams['xtick.direction'] = 'in'#将x周的刻度线方向设置向内
plt.rcParams['ytick.direction'] = 'in'#将y轴的刻度方向设置向内
plt.rcParams['mathtext.default'] = 'it'
# plt.rcParams['axes.facecolor'] = 'lightgrey'

action_cons_learn=np.load('plot_data/action_plot_constrain_learn.npy')
action_SMNN=np.load('plot_data/action_plot_SMNN.npy')
action_one_layer=np.load('plot_data/action_plot_one_layer.npy')

action_cons_learn=np.asarray(action_cons_learn)

state_w=np.arange(-0.1,0.1,0.002,dtype=np.float32)
fig=plt.figure(figsize=(20,5.0),dpi=100)
for idx in range(10):
    plt.subplot(2,5,idx+1)
    plt.plot(state_w,action_SMNN[idx,:],label='SMNN',linewidth=2.5)
    plt.plot(state_w,action_one_layer[idx,:],label='SNN',linewidth=2.5)
    plt.plot(state_w, action_cons_learn[idx, :], label='Ours',linewidth=2.5)
    plt.xlabel('Generator '+str(idx+1)+': $\omega (Hz)$',fontsize=16)
    if idx%5==0:
        plt.ylabel('Action u (p.u.)',fontsize=16)
    plt.grid(ls='--')
    plt.legend(bbox_to_anchor=(0.05, 1),fontsize=16, loc='upper left', borderaxespad=0.)
fig.tight_layout()
plt.savefig('figures/compare_action.pdf')
plt.show()

