import numpy as np
import matplotlib.pyplot as plt

plt.rc('font',family='Times New Roman')
plt.rcParams['xtick.direction'] = 'in'#将x周的刻度线方向设置向内
plt.rcParams['ytick.direction'] = 'in'#将y轴的刻度方向设置向内
plt.rcParams['mathtext.default'] = 'it'

loss_constrained_learn=np.load('loss_record_constrained_learn.npy')
loss_one_layer=np.load('../frequency_one_layer/loss_record_one_layer.npy')
loss_SMNN=np.load('../frequency_control_SMNN/loss_record_SMNN.npy')


timeLine=list(np.arange(1000))
plt.figure(figsize=(8,6),dpi=100)
plt.plot(timeLine,loss_one_layer,label='monotonic SNN')
plt.plot(timeLine,loss_constrained_learn,label='Ours')
plt.plot(timeLine,loss_SMNN,label='Scalable MNN')
plt.legend(loc='upper right', borderaxespad=0.)
plt.show()