import os
import random
import sys
import numpy as np
import torch

from torch.utils.data import DataLoader
from sklearn.metrics import accuracy_score

from heart_loader import *

def test():
    data_test_path='test.csv'
    test_dataset=HeartdataLoader(csv_path=data_test_path)
    print("Testing dataset size:", len(test_dataset))

    test_loader=DataLoader(test_dataset,batch_size=len(test_dataset),shuffle=True,drop_last=False)

    model=torch.load("model_5.pth")

    param_amout = 0
    for p in model.named_parameters():
        param_amout += p[1].numel()
    print('The total param amount:', param_amout)

    ## make prediction
    with torch.no_grad():
        for j,(x,y) in enumerate(test_loader):
            pred_y=model(x)

            true_y = y.detach().numpy()
            pred_y = pred_y.detach().numpy()
            pred_y_zero_one = np.where(pred_y > 0, 1, 0)

            acc = accuracy_score(true_y, pred_y_zero_one)

    print('Test accuracy: {}'.format(acc))



if __name__=="__main__":
    test()