from copy import deepcopy

from agentlab.agents.generic_agent_hinter import AGENT_GPT5_MINI

from jephhinter.configs import DEFAULT_EXP_PATH
from jephhinter.jephhinter_workflow import AgentLabRun, AgentLabRunConfig


def main():
    hint_db_path = "/Users/<user>/agentlab_results/2025-08-27_17-33-39-fullminiwob125-generic-visual2_with_hints_gpt-5-mini-2025-08-07/hint_db_updated.csv"
    n_jobs = 20
    n_repeats = 3
    agent_args = AGENT_GPT5_MINI
    agent_args.flags.obs.use_screenshot = True

    hint_modes = [
        ("none", False),
        ("direct", False),
        ("llm", False),
        ("emb", False),
        # ("llm", True),
        # ("emb", True),
    ]

    for hint_mode, skip_hints_for_current_task in hint_modes:
        print(
            f"\nStart retrieval {hint_mode}, skip current task hint: {skip_hints_for_current_task}"
        )
        use_task_hint = True
        if hint_mode == "none":
            use_task_hint = False
            hint_mode = "direct"
        agent = deepcopy(agent_args)
        agent.flags.task_hint_retrieval_mode = hint_mode  # type: ignore
        agent.flags.skip_hints_for_current_task = skip_hints_for_current_task
        config = AgentLabRunConfig(
            exp_root=f"{DEFAULT_EXP_PATH}/retrieve_workarena1",
            use_task_hint=use_task_hint,
            hint_db_path=hint_db_path,
            hint_mode=hint_mode,  # type: ignore
            n_jobs=n_jobs,
            n_repeats=n_repeats,
            benchmark_name="miniwob",
            agent_args=agent,
        )
        AgentLabRun(config).run()
        print(f"{hint_mode.capitalize()} retrieval completed.")


if __name__ == "__main__":
    main()
