import logging
from copy import deepcopy
from datetime import datetime

from agentlab.agents.generic_agent_hinter import AGENT_GPT5_MINI
from agentlab.agents.tool_use_agent import GPT_5
from dotenv import load_dotenv

from jephhinter.jephhinter_workflow import JephHinterWorkflow, JephHinterWorkflowConfig

logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)
load_dotenv()

if __name__ == "__main__":
    timestamp = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
    # timestamp = "2025-08-22_19-21-40" # to continue unfinished exp
    relaunch = False
    wf_config = JephHinterWorkflowConfig(
        exp_root=f"{timestamp}-workarena-subset1-gpt5hinter",
        hinter_models=[GPT_5],
    )
    wf_config.eval_config.n_jobs = 25
    wf_config.eval_config.n_repeats = 4
    wf_config.eval_config.backend = "ray"
    wf_config.eval_config.benchmark_name = "workarena_l1"  # "miniwob"

    # agent = ToolUseAgentArgs(model_args=GPT_5, config=DEFAULT_PROMPT_CONFIG)
    # agent.config.action_subsets = ("bid",)
    agent = AGENT_GPT5_MINI
    agent.flags.obs.use_screenshot = True

    wf_config.eval_config.agent_args = agent
    workflow = JephHinterWorkflow(wf_config)
    db_path = workflow.db_paths[0]
    if not relaunch:
        workflow.run_complete_workflow()
        logger.info(f"Hint database created at: {db_path}")
    else:
        logger.info(f"Hint database used: {db_path}")

    logger.info("Running with LLM hints retrieval")
    llm_eval_config = deepcopy(wf_config.eval_config)
    llm_eval_config.hint_mode = "llm"
    llm_eval_config.relaunch = relaunch
    workflow.run_with_hints(llm_eval_config)

    logger.info("Running with embeddings hints retrieval")
    emb_eval_config = deepcopy(wf_config.eval_config)
    emb_eval_config.hint_mode = "emb"
    emb_eval_config.relaunch = relaunch
    workflow.run_with_hints(emb_eval_config)

    logger.info("Running with LLM hints retrieval exclude current task hint")
    llm_eval_config = deepcopy(wf_config.eval_config)
    llm_eval_config.hint_mode = "llm"
    llm_eval_config.relaunch = relaunch
    llm_eval_config.agent_args.flags.skip_hints_for_current_task = True
    workflow.run_with_hints(llm_eval_config)

    logger.info("Running with embeddings hints retrieval exclude current task hint")
    emb_eval_config = deepcopy(wf_config.eval_config)
    emb_eval_config.hint_mode = "emb"
    emb_eval_config.relaunch = relaunch
    emb_eval_config.agent_args.flags.skip_hints_for_current_task = True
    workflow.run_with_hints(emb_eval_config)

    logger.info("All done")
