#!/usr/bin/env python3
"""
Test script for local JephHinter workflow execution.
This script demonstrates how to run the JephHinter workflow locally.
"""

import logging
import sys
from datetime import datetime
from pathlib import Path

# Add the project root to the Python path
project_root = Path(__file__).parent.parent
sys.path.insert(0, str(project_root))

from agentlab.agents.tool_use_agent import (
    GPT_5,
)

from agentlab.agents.generic_agent_hinter.tmlr_config import get_base_agent, get_vision_agent
from jephhinter.configs import AgentLabRunConfig, JephHinterWorkflowConfig
from jephhinter.jephhinter_workflow import (
    run_workflow_locally,
    run_hint_generation_and_evaluation_locally,
)

log_format = "%(asctime)s - %(filename)s:%(lineno)d - %(funcName)s - %(levelname)s - %(message)s"
logging.basicConfig(level=logging.INFO, format=log_format, datefmt="%Y-%m-%d %H:%M:%S", force=True)

logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)

if __name__ == "__main__":
    logger.info("JephHinter Workflow Local Execution Test")
    logger.info("=" * 50)

    # List of agents to test
    agents_to_test = [
        get_base_agent("openai/gpt-5-mini-2025-08-07"),
        # get_base_agent("openai/gpt-5-nano-2025-08-07"),
    ]

    # List of JephHinter models to test
    hinter_models = [
        GPT_5,
    ]

    # # Example 1: Run with data collection (recommended for first time)
    # timestamp = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
    # configs = []
    # for agent_args in agents_to_test:
    #     exp_root = f"{timestamp}-jephhinter-{agent_args.chat_model_args.model_name}"
    #     configs.append(
    #     JephHinterWorkflowConfig(
    #         exp_root=exp_root,
    #         eval_config=AgentLabRunConfig(agent_args=agent_args),
    #         hinter_models=hinter_models,
    #     )
    #     )
    # logger.info("\n=== Example 1: Run with data collection ===")
    # for cfg in configs:
    #     run_workflow_locally(cfg)

    # # Example 2: Run without data collection (use existing traces)
    timestamp = "2025-09-11_16-59-55"
    configs = []
    for agent_args in agents_to_test:
        exp_root = f"{timestamp}-jephhinter-{agent_args.chat_model_args.model_name}"
        configs.append(
        JephHinterWorkflowConfig(
            exp_root=exp_root,
            eval_config=AgentLabRunConfig(agent_args=agent_args),
            hinter_models=hinter_models,
        )
        )

    logger.info("\n=== Example 2: Run without data collection ===")
    for cfg in configs:
        run_hint_generation_and_evaluation_locally(cfg)

    # # Example 3: Run only data collection for specific agents
    # logger.info("\n=== Example 3: Run only data collection ===")
    # for cfg in configs:
    #     run_data_collection_only_locally(cfg)

    logger.info("\n" + "=" * 50)
    logger.info("Test completed!")
