## Utility functions
import logging
import subprocess
import time
import subprocess, os


def run_subprocess(command, n_retry=100):
    """Utility function to run subprocess commands with error handling."""
    itr = 0
    my_env = os.environ.copy()

    while itr < n_retry:
        try:
            # Use Popen instead of run
            process = subprocess.Popen(
                command,
                shell=True,
                env=my_env,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
                text=True,
            )

            # Capture output
            stdout, stderr = process.communicate()

            # Check return code (similar to check=True behavior)
            if process.returncode != 0:
                raise subprocess.CalledProcessError(process.returncode, command, stdout, stderr)

            # Create a result object similar to what subprocess.run would return
            class Result:
                def __init__(self, returncode, stdout, stderr):
                    self.returncode = returncode
                    self.stdout = stdout
                    self.stderr = stderr

            return Result(process.returncode, stdout, stderr)

        except subprocess.CalledProcessError as e:
            logging.error(f"An error occurred while executing command: {command}")
            logging.error(e.stderr)  # Print the error output
            itr += 1
            time.sleep(10)
    raise Exception(f"An error occurred while executing command: {command}")
