# Training the Untrainable: Introducing Inductive Bias via Representational Alignment
This code covers our guidance approach.

We use target and student model in this code to refer to guide and target model in the paper respectively. Use `[--rep_sim]` flag to incorporate representational alignment with CKA. For all experiments, we use a batch size of 256.

See `notebooks/demo_notebook.ipynb` for a simplified overview of how our approach works. You can also step through the code below to understand how to use guidance.
## Image Object Classification
```
python -m imagenet-comparison.image_class --exp_name [EXP_NAME] --target_model [TARGET_MODEL] --student_model [STUDENT_MODEL] --batch_size [BATCH_SIZE] --lr [LEARNING_RATE] [--rep_sim] [--repdist] [REPDIST]
```

## Language Modeling
```
python -m languge_modeling.language_model --exp_name [EXP_NAME] --task next-word --target_model [TARGET_MODEL] --student_model [STUDENT_MODEL] --batch_size [BATCH_SIZE] --lr [LEARNING_RATE] [--rep_sim] [--repdist] [REPDIST]
```

## Copy-Paste
```
python -m languge_modeling.language_model --exp_name [EXP_NAME] --task copy-paste --target_model [TARGET_MODEL] --student_model [STUDENT_MODEL] --batch_size [BATCH_SIZE] --lr [LEARNING_RATE] [--rep_sim] [--repdist] [REPDIST]
```

## Parity
```
python -m languge_modeling.language_model --exp_name [EXP_NAME] --task parity --target_model [TARGET_MODEL] --student_model [STUDENT_MODEL] --batch_size [BATCH_SIZE] --lr [LEARNING_RATE] [--rep_sim] [--repdist] [REPDIST]
```