# Learning Mean Field Games on Sparse Graphs: A Hybrid Graphex Approach
This repository is the official code for the paper "Learning Mean Field Games on Sparse Graphs: A Hybrid Graphex Approach"

## Setup
Create a python environment and install requirements:
```shell script
pip install -r requirements.txt
```

If needed, set PYTHONPATH to include the top-level folder, e.g.
```shell script
export PYTHONPATH=$PYTHONPATH:$(pwd)
```

## Network Data
Download datasets (e.g. the Flickr data set is part of the KONECT database and is available at http://socialnetworks.mpi-sws.mpg.de/data/flickr-growth.txt.gz):
```shell script
python ./setup_dl_datasets.py
```

## Run Experiments
Run all experiments
```shell script
python ./exp_1.py
python ./exp_2.py
python ./exp_3.py
```

## Evaluate Results
Plot and output all experiment results as in the paper
```shell script
python ./plot_1_exploitability.py
python ./plot_2_propagation_of_chaos.py
python ./plot_3_qualitative_trajectories.py
python ./plot_4_print_table_datasets.py
python ./plot_5_print_diff_LP.py
```
