import argparse

from Rumor_graphex import RumorGraphex
from SIR_graphex import SIRGraphex
from SIS_graphex import SISGraphex


def parse_args():
    parser = argparse.ArgumentParser(description="M3FG")
    parser.add_argument('--game', help='game to solve', default="SIS")
    parser.add_argument('--fp_iterations', type=int, help='number of fp iterations', default=7)
    parser.add_argument('--id', type=int, help='experiment id', default=0)

    parser.add_argument("--gamma", type=float, default=0.99, help="Discount factor")
    parser.add_argument("--softmax", action="store_true", default=False, help="Use softmax instead of argmax")
    parser.add_argument("--temperature", type=float, default=0.01, help="Softmax temperature")
    parser.add_argument("--variant", default="fpi", choices=["fpi", "fp", "omd"])
    parser.add_argument("--graphex", default="separable")
    parser.add_argument("--dataset", default="graphex")

    parsed, unknown = parser.parse_known_args()
    def isfloat(num):
        try:
            float(num)
            return True
        except ValueError:
            return False
    def isint(num):
        try:
            int(num)
            return True
        except ValueError:
            return False
    for arg in unknown:
        if arg.startswith(("-", "--")):
            parser.add_argument(arg.split('=')[0],
                                type=int if isint(arg.split('=')[1]) else float if isfloat(arg.split('=')[1]) else str)

    return parser.parse_args()


def generate_config(args):
    return generate_config_from_kw(**vars(args))


def generate_config_from_kw(temperature=0.01, softmax=0, graphex="separable", dataset="graphex", **kwargs):
    kwargs['temperature'], kwargs['softmax'], kwargs['graphex'], kwargs['dataset'] = \
        temperature, softmax, graphex, dataset

    kwargs['exp_dir'] = "./results/%s_%s_%d_%f_%d_%s_%s" \
               % (kwargs['game'], kwargs['variant'], kwargs['fp_iterations'],
                  kwargs['temperature'], kwargs['softmax'], kwargs['graphex'], kwargs['dataset'])
    kwargs['exp_dir'] += f"/"

    from pathlib import Path
    Path(f"{kwargs['exp_dir']}").mkdir(parents=True, exist_ok=True)

    if kwargs['game'] == 'SIS':
        kwargs['game'] = SISGraphex
    elif kwargs['game'] == 'SIR':
        kwargs['game'] = SIRGraphex
    elif kwargs['game'] == 'RS':
        kwargs['game'] = RumorGraphex
    else:
        raise NotImplementedError

    return kwargs


def parse_config():
    args = parse_args()
    return generate_config(args)
