import os
import subprocess
import tarfile
import urllib.request
from pathlib import Path

Path(f"./real_network_data").mkdir(parents=True, exist_ok=True)

datasets = ["download.tsv.prosper-loans.tar.bz2", "download.tsv.petster-friendships-dog.tar.bz2",
            "download.tsv.soc-pokec-relationships.tar.bz2", "download.tsv.livemocha.tar.bz2",
            "download.tsv.flickr-growth.tar.bz2", "download.tsv.loc-brightkite_edges.tar.bz2",
            "download.tsv.facebook-wosn-wall.tar.bz2", "download.tsv.hyves.tar.bz2", ]

for dataset in datasets:
    if not os.path.exists(f"./real_network_data/{dataset}"):
        print(fr"Downloading {dataset}", flush=True)
        urllib.request.urlretrieve(f"http://konect.cc/files/{dataset}",
                                   f"./real_network_data/{dataset}")

os.chdir(f"./real_network_data")
for dataset in datasets:
    print(fr"Extracting {dataset}", flush=True)
    tar = tarfile.open(f"./{dataset}", "r:bz2")
    tar.extractall()
    tar.close()

    if dataset == "download.tsv.petster-friendships-dog.tar.bz2":
        p = subprocess.Popen(['mv',
                              fr'petster-friendships-dog/out.petster-friendships-dog-uniq',
                              fr'petster-friendships-dog/out.petster-friendships-dog'
                              ])
