import subprocess
import time

if __name__ == '__main__':
    import multiprocessing

    num_cores = multiprocessing.cpu_count()
    cores_per_task = 1
    max_tasks = num_cores // cores_per_task
    child_processes = []

    for variant in ["fpi", "omd", ]:
        for game in ['SIS', 'SIR', 'RS', ]:
            p = subprocess.Popen(['python',
                                  './main_fp.py',
                                  f'--cores={cores_per_task}',
                                  f'--game={game}',
                                  f'--fp_iterations={5000}',
                                  f'--temperature={50}',
                                  f'--variant={variant}',
                                  ])
            child_processes.append(p)

            time.sleep(5)

            while len(child_processes) >= max_tasks:
                for p in list(child_processes):
                    if p.poll() is not None:
                        child_processes.remove(p)
                    time.sleep(1)

    for p in child_processes:
        p.wait()
