import subprocess
import time

if __name__ == '__main__':
    import multiprocessing

    num_cores = multiprocessing.cpu_count()
    cores_per_task = 8
    max_tasks = num_cores // cores_per_task
    child_processes = []

    datasets = ["prosper-loans", "petster-friendships-dog", "soc-pokec-relationships", "livemocha",
                "flickr-growth", "loc-brightkite_edges", "facebook-wosn-wall", "hyves", ]
    sigmas = [0.058, 0.071, 0.108, 0.075, 0.506, 0.376, 0.252, 0.582]

    for game in ['SIS', 'SIR', 'RS', ]:
        for dataset, sigma in zip(datasets, sigmas):
            p = subprocess.Popen(['python',
                                  './plot_4run.py',
                                  f'--game={game}',
                                  f'--fp_iterations={5000}',
                                  f'--temperature={50}',
                                  f'--variant={"omd"}',
                                  f'--dataset={dataset}',
                                  f'--sigma={sigma}',
                                  ])
            child_processes.append(p)

            time.sleep(5)

            while len(child_processes) >= max_tasks:
                for p in list(child_processes):
                    if p.poll() is not None:
                        child_processes.remove(p)
                    time.sleep(1)

    for p in child_processes:
        p.wait()
