# Numeric Symbols in ANNs

## Description
This is the code repository for the project that uses DAS and other interventions to find distributed counting variables. The project's goals are to demonstrate the utility of Distributed Alignment Search in sequence based neural networks and further our understanding of symbolic reasoning and numeric cognition.

## Setup
After cloning the repo, install all necessary packages locally:

```sh
python3 -m pip install --user -r requirements.txt
```

## How to Use this Repo
To train a model, run the following from the top level of the repository.

```
$ CUDA_VISIBLE_DEVICES=0 python3 main.py path_to_config.yaml
```

We have provided some useful bash scripts to allow you to train all the models used in the paper.

```
$ bash make_models.sh
```

This will spawn a number of tmux sessions and make heavy use of your GPUs. Feel free to reduce the GPU workload
by running each separate model file individually.

The scripts to run the analyses are contained in the `iclr_main_exps` folder.
