#!/bin/bash

export CUDA_VISIBLE_DEVICES=2
root_folder="/data2/grantsrb/das_saves/devo_gru/devo_gru_0_sd_save_mod1_lr0.001/"


for model_folder in "checkpt_0.pt" "checkpt_10.pt" "checkpt_20.pt" "checkpt_30.pt" "checkpt_40.pt" "checkpt_50.pt" "checkpt_60.pt" "checkpt_70.pt" "checkpt_80.pt" "checkpt_90.pt""checkpt_100.pt" 
do
    exp_folder="${root_folder}${model_folder}"
    python3 experiment_script.py $exp_folder full_configs/count_any2any.yaml
    python3 experiment_script.py $exp_folder full_configs/count_resp2demo.yaml
    python3 experiment_script.py $exp_folder full_configs/count_demo2resp.yaml
    
    python3 experiment_script.py $exp_folder full_configs/phase_any2any.yaml
    python3 experiment_script.py $exp_folder full_configs/phase_resp2demo.yaml
    python3 experiment_script.py $exp_folder full_configs/phase_demo2resp.yaml
    
    python3 experiment_script.py $exp_folder full_configs/democount_any2any.yaml
    python3 experiment_script.py $exp_folder full_configs/democount_resp2demo.yaml
    python3 experiment_script.py $exp_folder full_configs/democount_demo2resp.yaml
    
    python3 experiment_script.py $exp_folder full_configs/respcount_any2any.yaml
    python3 experiment_script.py $exp_folder full_configs/respcount_resp2demo.yaml
    python3 experiment_script.py $exp_folder full_configs/respcount_demo2resp.yaml
    
    python3 experiment_script.py $exp_folder full_configs/count_any2any.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/count_resp2demo.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/count_demo2resp.yaml relaxed=True
    
    python3 experiment_script.py $exp_folder full_configs/phase_any2any.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/phase_resp2demo.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/phase_demo2resp.yaml relaxed=True
    
    python3 experiment_script.py $exp_folder full_configs/democount_any2any.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/democount_resp2demo.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/democount_demo2resp.yaml relaxed=True
    
    python3 experiment_script.py $exp_folder full_configs/respcount_any2any.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/respcount_resp2demo.yaml relaxed=True
    python3 experiment_script.py $exp_folder full_configs/respcount_demo2resp.yaml relaxed=True
    
done
unset CUDA_VISIBLE_DEVICES
