import pandas as pd
import os
import sys
import numpy as np

try:
    import dl_utils.save_io as save_io
except:
    sys.path.append("../")
    sys.path.append("./")
    import dl_utils.save_io as save_io


if __name__=="__main__":
    model_folders = []
    args = sys.argv[1:]
    for arg in args:
        if save_io.is_model_folder(arg):
            model_folders.append(arg)
        elif save_io.is_exp_folder(arg):
            mfs = save_io.get_model_folders(
                arg, incl_full_path=True, incl_empty=False)
            for f in mfs:
                model_folders.append(f)
        elif ".csv"==arg[-4:]:
            model_folders.append(arg)

    for model_folder in model_folders:
        summary = ""
        s = "\n"+model_folder+":\n"
        print(s)
        summary += s
        if os.path.isdir(model_folder):
            csvs = os.listdir(model_folder)
        else:
            csvs = [model_folder.split("/")[-1]]
            model_folder = "/".join(model_folder.split("/")[:-1])
        for csv in csvs:
            if ".csv"==csv[-4:]:
                name = csv[:-4]
                s = f"\n\n    {name}:\n"
                print(s)
                summary += s + "\n"
                try:
                    df = pd.read_csv(os.path.join(model_folder, csv))
                    best_df = df.sort_values(
                        by="val_correct", ascending=False)
                    best_df = best_df.drop_duplicates(["n_neurons"])
                    df = df.sort_values(
                        by=["epoch", "n_neurons"], ascending=False)
                    df = df.drop_duplicates(["n_neurons"])
                except:
                    print("Error occurred in", csv)
                    print("Probably not a DAS csv...")
                    continue
                for row in range(len(df)):
                    n_neurons = df.iloc[row]["n_neurons"]
                    print("\n    NNeurons:", n_neurons, "-- Name:", name)
                    print("\n    Last Epoch:")
                    for col in df.columns:
                        print(f"        {col}: {df.iloc[row][col]}")
                    print("\n    Best Epoch:")
                    bdf = best_df.loc[best_df["n_neurons"]==n_neurons]
                    for col in bdf.columns:
                        print(f"        {col}: {bdf.iloc[0][col]}")
                    print()


