#!/bin/bash

export CUDA_VISIBLE_DEVICES=5
root_folder="/data2/grantsrb/das_saves/pretrigger_nolnorm_gru/"


#pretrigger_nolnorm_gru_2_seed333333
for model_folder in "pretrigger_nolnorm_gru_1_seed222222" "pretrigger_nolnorm_gru_4_seed555555"
do
    exp_folder="${root_folder}${model_folder}"

    python3 experiment_script.py $exp_folder multr_configs/multi_count_any2any.yaml
    python3 experiment_script.py $exp_folder multr_configs/multi_count_demo2resp.yaml
    python3 experiment_script.py $exp_folder multr_configs/multi_count_resp2demo.yaml

    python3 experiment_script.py $exp_folder multr_configs/phase_any2any.yaml  
    python3 experiment_script.py $exp_folder multr_configs/phase_resp2demo.yaml
    python3 experiment_script.py $exp_folder multr_configs/phase_demo2resp.yaml

    python3 experiment_script.py $exp_folder multr_configs/trigid_mc_any2any.yaml         
    python3 experiment_script.py $exp_folder multr_configs/trigid_mc_demo2demo.yaml       
    python3 experiment_script.py $exp_folder multr_configs/trigid_mc_ignore_demo2demo.yaml
    python3 experiment_script.py $exp_folder multr_configs/trigid_mc_resp2resp.yaml       

    python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_any2any.yaml
    python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_demo2resp.yaml
    python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_resp2demo.yaml

    python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_any2any.yaml
    python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_demo2resp.yaml
    python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_resp2demo.yaml

    python3 experiment_script.py $exp_folder multr_configs/sing_count_any2any.yaml
    python3 experiment_script.py $exp_folder multr_configs/sing_count_demo2demo.yaml
    python3 experiment_script.py $exp_folder multr_configs/sing_count_resp2resp.yaml

    for tid in 7 8 9
    do
        python3 experiment_script.py $exp_folder multr_configs/multi_count_any2any.yaml   trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/multi_count_demo2resp.yaml trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/multi_count_resp2demo.yaml trigger_id=$tid

        python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_any2any.yaml   trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_demo2resp.yaml trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/demo_multi_count_resp2demo.yaml trigger_id=$tid

        python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_any2any.yaml   trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_demo2resp.yaml trigger_id=$tid
        python3 experiment_script.py $exp_folder multr_configs/resp_multi_count_resp2demo.yaml trigger_id=$tid
    done
done


unset CUDA_VISIBLE_DEVICES
