import numpy as np

def explicit_tens(
        inpt_id,
        variables,
        word2id,
        *args, **kwargs):
    """
    This model holds one variable for the current count of the
    process and a phase variable that tracks what the input token was.
    It ultimately counts up in the demo phase and
    then back down in the response phase.

    Args:
        inpt_id: int
            the current token in the sequence
        variables: dict
            "op": int or None
                the current operation in the process.
            "cumu_ones": int
                the ones place in the cumulative value
            "cumu_tens": int
                the tens place in the cumulative value
        word2id: dict
            A dict to convert token strings to id ints
            tokens (str): ids (int)
    Returns:
        tok_id: int
            returns a list of ints representing the sequence
        variables: dict
            "count": int
                the current count of the process.
            "phase": bool or int
                0: demonstration phase
                1: response phase
    """
    if variables is None:
        variables = {"op": None, "cumu_ones": 0, "cumu_tens": 0}

    variables = {k:v for k,v in variables.items()}
    if inpt_id==bos_id:
        variables["op"] = None
        variables["cumu_ones"] = 0
        variables["cumu_tens"] = 0
        variables["mask"] = 0
        variables["cumu_val"] = 0
        init_val = 
        return , variables
    elif inpt_id==eos_id or inpt_id==pad_id:
        variables["mask"] = 0
        return pad_id, variables
    elif inpt_id in trigger_ids:
        if not pre_trigger or variables["count"]!=0:
            variables["phase"] = 1
            variables["mask"] = 1
            token_id = resp_id
        else:
            variables["phase"] = 0
            variables["mask"] = 0
            token_id = demo_ids[np.random.randint(0,len(demo_ids))]
    # allows phase change when no trigger
    elif variables["phase"]==0 and inpt_id==resp_id:
        variables["phase"] = 1
        variables["mask"] = 1
        variables["count"] -= 1
        variables["resp_count"] += 1
        token_id = resp_id
    elif variables["phase"]==0 and inpt_id in demo_ids:
        variables["count"] += 1
        variables["mask"] = 0
        token_id = demo_ids[np.random.randint(0,len(demo_ids))]
    elif variables["phase"]>0 and inpt_id==resp_id:
        variables["count"] -= 1
        variables["mask"] = 1
        token_id = resp_id

        #TODO: used for removing first step after trigger from response phase sampling
        variables["resp_count"] += 1
        #TODO:

    if variables["count"]<=0 and variables["phase"]>0:
        token_id = eos_id
        variables["mask"] = 1
    return token_id, variables

