#!/bin/bash
# Use this script to run the DAS experiments

lr=0.001
n_epochs=500
relaxed=False # if false, uses orthonormal rotation matrix. if true, learns diagonal scaling matrix applied before rotation
boundless=False # learnable swap dimensionality if true
use_best=True # if false, uses most recent epoch. if true, uses epoch with highest validation score
gpus=(0 1 2 3 4 5 6 7)
root_folder="iclr2025/"


mkdir logfiles
cuda_idx=0
procs=()
for exp_folder in "rnn_multiobj" "rnn_singleobj" "rnn_sameobj" "tformer_multiobj" "tformer_singleobj" "tformer_sameobj"
do
    for config in "count_any2any.yaml" "democount_any2any.yaml" "respcount_any2any.yaml" "phase_any2any.yaml"
    do
        for seed in 10 11 22 33 44 55
        do
           exp_root="${root_folder}${exp_folder}/"
           for model_folder in `ls ${exp_root}`; do
                if [[ $model_folder == *seed${seed}* && $model_folder != *Mamba* ]]; then
                    model_path="${exp_root}${model_folder}"
                    log="logfiles/cuda${cuda}.log"
                    #python3 delay.py &
                    cuda=${gpus[$cuda_idx]}
                    CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${model_path} full_das_configs/$config relaxed=${relaxed} n_epochs=$n_epochs lr=$lr use_best=$use_best boundless_das=${boundless} &> $log &
                    echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${model_path} full_das_configs/$config relaxed=${relaxed} n_epochs=$n_epochs lr=$lr use_best=$use_best boundless_das=${boundless}
                    procs+=($!)
                    cuda_idx=$((1+$cuda_idx))
                    
                    if [[ ${cuda_idx} == ${#gpus[@]} ]]; then
                        for proc in ${procs[@]}
                        do
                             echo Waiting on pid $proc
                             wait $proc
                        done
                        cuda_idx=0
                        procs=()
                    fi
                fi
            done

        done
    done
done

for proc in ${procs[@]}
do
     echo Waiting on pid $proc
     wait $proc
done
