#!/bin/bash
root_folder="iclr2025/rnn_multiobj"
cuda_offset=0
lr=0.001
n_epochs=500
n_train=10000
boundless_das=False
config="count_any2any.yaml"
model_type="GRU"
seeds=(10 11 22 33 44 55)

for (( checkpt_num=0; checkpt_num<=110; checkpt_num+=5 ))
do
    checkpt="checkpt_${checkpt_num}.pt"
    cuda=$cuda_offset
    procs=()

    for seed in ${seeds[@]}
    do
        for model_folder in `ls ${root_folder}`
        do
            if [[ $model_folder == *seed${seed}* && $model_folder == *${model_type}* ]]; then
                exp_folder="${root_folder}/${model_folder}/${checkpt}"
                log="logfiles/size_cuda${cuda}.log"
                #python3 delay.py &
                CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train} &> $log &
                echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train}

                procs+=($!)
                cuda=$((1+$cuda))
            fi
        done
    done
    for proc in ${procs[@]}
    do
         echo Waiting on pid $proc
         wait $proc
    done
done

for (( checkpt_num=110; checkpt_num<=210; checkpt_num+=10 ))
do
    checkpt="checkpt_${checkpt_num}.pt"
    cuda=$cuda_offset
    procs=()
    for seed in ${seeds[@]}
    do
        for model_folder in `ls ${root_folder}`
        do
            if [[ $model_folder == *seed${seed}* && $model_folder == *${model_type}* ]]; then
                exp_folder="${root_folder}/${model_folder}/${checkpt}"
                log="logfiles/size_cuda${cuda}.log"
                CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train} &> $log &
                echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train}

                procs+=($!)
                cuda=$((1+$cuda))
            fi
        done
    done
    for proc in ${procs[@]}
    do
         echo Waiting on pid $proc
         wait $proc
    done
done

for (( checkpt_num=210; checkpt_num<=310; checkpt_num+=20 ))
do
    checkpt="checkpt_${checkpt_num}.pt"
    cuda=$cuda_offset
    procs=()
    for seed in ${seeds[@]}
    do
        for model_folder in `ls ${root_folder}`
        do
            if [[ $model_folder == *seed${seed}* && $model_folder == *${model_type}* ]]; then
                exp_folder="${root_folder}/${model_folder}/${checkpt}"
                log="logfiles/size_cuda${cuda}.log"
                CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train} &> $log &
                echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train}

                procs+=($!)
                cuda=$((1+$cuda))
            fi
        done
    done
    for proc in ${procs[@]}
    do
         echo Waiting on pid $proc
         wait $proc
    done
done

for (( checkpt_num=310; checkpt_num<=700; checkpt_num+=40 ))
do
    checkpt="checkpt_${checkpt_num}.pt"
    cuda=$cuda_offset
    procs=()
    for seed in ${seeds[@]}
    do
        for model_folder in `ls ${root_folder}`
        do
            if [[ $model_folder == *seed${seed}* && $model_folder == *${model_type}* ]]; then
                exp_folder="${root_folder}/${model_folder}/${checkpt}"
                log="logfiles/size_cuda${cuda}.log"
                CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train} &> $log &
                echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${exp_folder} full_das_configs/$config boundless_das=${boundless_das} n_epochs=$n_epochs lr=$lr n_train_samples=${n_train}

                procs+=($!)
                cuda=$((1+$cuda))
            fi
        done
    done
    for proc in ${procs[@]}
    do
         echo Waiting on pid $proc
         wait $proc
    done
done
