#!/bin/bash
# Use this script to run the DAS experiments for the transformer solution

n_epochs=2
use_best=True # if false, uses most recent epoch. if true, uses epoch with highest validation score
cuda=0
root_folder="iclr2025/"
n_train_samples=1000


mkdir logfiles

for config in  "noswap_demo2demo.yaml" "noswap_notlast2notlast.yaml" "count_end2resp.yaml"  "noswap_notlast2end_hacky.yaml"
do
    for exp_folder in "rnn_multiobj" "rnn_singleobj" "rnn_sameobj" "tformer_multiobj" "tformer_singleobj" "tformer_sameobj"
    do
        for seed in 10 11 22 33 44 55
        do
           for layer in  "layers.0" "identities.0" "layers.1.self_attn.out_proj" "layers.0.self_attn.out_proj"  
           do
                procs=()
                exp_root="${root_folder}${exp_folder}/"
                for model_folder in `ls ${exp_root}`; do
                     if [[ $model_folder == *seed${seed}* ]]; then
                         model_path="${exp_root}${model_folder}"
                         log="logfiles/cuda${cuda}.log"
                             #python3 delay.py &
                             echo CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${model_path} full_das_configs/$config n_epochs=$n_epochs use_best=$use_best n_neurons=10000 n_train_samples=$n_train_samples layers=$layer 
                             CUDA_VISIBLE_DEVICES=${cuda} python3 run_das.py ${model_path} full_das_configs/$config n_epochs=$n_epochs use_best=$use_best n_neurons=10000 n_train_samples=$n_train_samples layers=$layer
                     fi
                done
            done
        done
    done
done
