def num2base(n, b):
    """
    Converts a number to a new base returning a string.
    (Taken from Stack Overflow)

    Args:
        n: int
            the number that is currently in base 10 that you would
            like to convert to another base b
        b: int
            the new number base
    Returns:
        numerals: list of ints
            the numerals of the argued number in the new base
    """

    if n == 0:
        return [0]
    numerals = []
    while n:
        numerals.append(int(n % b))
        n //= b
    return numerals[::-1]

def sep_digit_fxn(value, reverse_digits=False, base=10):
    if base!=10:
        val_list = [str(v) for v in num2base(value, base)]
    else:
        val_list = [s for s in str(value)]
    if reverse_digits:
        val_list = list(reversed(val_list))
    return val_list

