
#!/bin/bash

# Array of configuration files
configs=("tiny" "small" "medium" "large")

# Loop through each configuration
for config in "${configs[@]}"; do
    echo "Training model with ${config} configuration..."
    python scripts/main.py \
        --model_dir models/${config}_model_citeseq_15/ \
        --gibbs_iterations 2 \
        --rho_scheduling_type linear \
        --rho_start 1.0 \
        --rho_end .5 \
        --initial_x measurement \
        --result_dir results/citeseq_${config} \
        --save_data \
        --initial_x measurement \
        --test_on test \
        --from_scratch \
        --checkpoints_to_keep 2000

    echo "Completed training for ${config} configuration."
    echo "----------------------------------------"
done

echo "All models trained successfully!"