
#!/bin/bash

# Array of configuration files
configs=("15" "30" "50")

# Loop through each configuration
for config in "${configs[@]}"; do
    echo "Training model with ${config} configuration..."
    python scripts/main.py \
        --model_dir models/large_model_pancreas_${config}/ \
        --dataset single_cell \
        --config_file data/pancreas/full_dimensions.json \
        --test_noise_level=0.0 \
        --gibbs_iterations 10 \
        --rho_scheduling_type linear \
        --rho_start 1.0 \
        --rho_end .5 \
        --initial_x measurement \
        --result_dir results/pancreas__${config} \
        --save_data \
        --initial_x measurement \
        --test_on test \
        --from_scratch \
        --checkpoints_to_keep 1000

    echo "Completed training for ${config} configuration."
    echo "----------------------------------------"
done

echo "All models trained successfully!"